<?php

/**
 *
 * Copyright (c) 2013, EvoStream Inc.  All rights reserved.
 *
 * This software is provided free of charge to be used solely in conjunction
 * with the EvoStream Media Server.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the source code retain the above 
 * copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 **/

//Important Note: Functions are used by javascript. All documents should be referenced in relation to 
//the javascript using it. 
require '../settings/account-settings.php';

$users = loadHtdigest('../'.PASSWORDS);

switch ((string) $_POST['cmd']) {
	case "loadAccounts":
		echo json_encode($users);
		exit();
	case "changePassword":
		$result = accessPassword($_POST['username'], $_POST['password'], 'change');
		echo json_encode($result);
		exit();
	case "resetPassword":
		$result = accessPassword($_POST['username'], 'password', 'change');
		echo json_encode($result);
		exit();
	case "deleteAccount":
		$result = accessPassword($_POST['username'], '', 'delete');
		echo json_encode($result);
		exit();
	case "addAccount":
		$result = accessPassword($_POST['username'], $_POST['password'], 'new');
		echo json_encode($result);
		exit();
	default:
		// Nothing to do...
		exit();
}

function accessPassword($username, $newPassword, $action) {
	$htdigest = '../'.PASSWORDS;
	$secdom = REALM;
	$adjustLine = false;
	$addNewAccount = true;
	$output = '';
	$result = array('success' => true);

	$in = fopen($htdigest, 'r');
	while (($line = fgets($in, 4096)) !== false) {
		$line = rtrim($line);

		$a = explode(':', $line);
		if ($a[0] == $username && $a[1] == $secdom) {
			if ($action == 'new') {
				$addNewAccount = false;
				$result['success'] = false;
				$result['message'] = 'Account already exists';
			}
			if ($action == 'change') {
				$a[2] = md5("$username:$secdom:$newPassword");
			}
			if ($action == 'delete') {
				unset($a[0]);
				unset($a[1]);
				unset($a[2]);
				$adjustLine = true;
			}
		}
		$output .= implode(':', $a) . "\n";
	}

	if (($action == 'new') && $addNewAccount) { // assume it's a new password
		$hash = md5("$username:$secdom:$newPassword");
		$output .= "$username:$secdom:$hash\n";
	}

	fclose($in);
	$out = fopen("$htdigest", 'w');
	fwrite($out, $output);
	fclose($out);
	
	if ($adjustLine) {
		$in = fopen($htdigest, 'r');
		$output = '';
		while (($line = fgets($in, 4096)) !== false) {
			$line = rtrim($line);
			
			if ($line != '') {
				$output .= $line. "\n";
			}
		}

		fclose($in);
		$out = fopen("$htdigest", 'w');
		fwrite($out, $output);
		fclose($out);
	}	
	
	return $result;

}

?>
