<?php
/**
 *
 * Copyright (c) 2013, EvoStream Inc.  All rights reserved.
 *
 * This software is provided free of charge to be used solely in conjunction
 * with the EvoStream Media Server.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the source code retain the above 
 * copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * */
require 'phpacct/login.php';

error_reporting(E_ERROR | E_PARSE);

//Clear Variables
$emsLocationText = "";
$errEmsLocationText = "";
$errLicFile = "";
$sucLicFile = "";
$backButton = "";

$installButton = '<button type="submit" id="installLic" class="left small pop blue" style="margin-top: 20px;">Install License</button>';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
	$exts = array('lic');
	$tmp = explode('.', $_FILES["licFile"]["name"]);
	$validation = TRUE;

	if (!in_array(end($tmp), $exts)) {
		$errLicFile = '<div class="notice error"><span class="icon" data-icon="x"></span>Invalid license file<a href="#close" class="icon close" data-icon="x"></a></div>';
		$validation = FALSE;
	}

	$checkWindows = strpos(PHP_OS, "WIN");
	$emsConfigLocation = "";
	$licCopyFile = "";

	if ($checkWindows !== FALSE) {
		$emsConfigLocation = $_POST['emsLocationText'] . '\config';
		$licCopyFile = '\License.lic';
	} else {
		$emsConfigLocation = $_POST['emsLocationText'];
		$licCopyFile = '/License.lic';
	}

	if ((!is_dir($emsConfigLocation)) || (fileperms($emsConfigLocation) !== 16895)) {
		$errEmsLocationText = '<div class="notice error"><span class="icon" data-icon="x"></span>Invalid file directory. <br />Please check if directory exists and also directory permissions. <a href="#close" class="icon close" data-icon="x"></a></div>';
		$validation = FALSE;
		$emsLocationText = $_POST['emsLocationText'];
	}else{
		$emsLocationText = $_POST['emsLocationText'];
	}

	if ($validation == TRUE) {
		if (!copy($_FILES["licFile"]["tmp_name"], $emsConfigLocation . $licCopyFile)) {
			$errEmsLocationText = '<div class="notice error"><span class="icon" data-icon="x"></span>Failed to copy License.lic. Click refresh and try again.<a href="#close" class="icon close" data-icon="x"></a></div>';
			$backButton = '<button type="button" id="refreshInstall" class="left small pop blue" style="margin-top: 20px;">Refresh</button>';
			$emsLocationText = $_POST['emsLocationText'];
			$installButton = "";
		} else {
			$sucLicFile = '<div class="notice success"><span class="icon" data-icon="x"></span>License successfully installed<a href="#close" class="icon close" data-icon="x"></a></div>';
			$installButton = "";
			$backButton = '<button type="button" id="goBack" class="left small pop blue" style="margin-top: 20px;">Back to Web UI</button>';
		}
	}
}
?>
<!DOCTYPE html>
<html>
    <head>
        <title>EvoStream Media Server</title>
        <meta charset="UTF-8">
        <meta name="description" content="" />

        <!-- Grab CDN copy then if offline, revert to local copy -->
        <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <script>window.jQuery || document.write('<script src="js/jquery-1.7.1.min.js"><\/script>')</script>
        <!--[if lt IE 9]><script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
        <script type="text/javascript" src="js/prettify.js"></script>                                   <!-- PRETTIFY -->
        <script type="text/javascript" src="js/kickstart.js"></script>                                  <!-- KICKSTART -->
        <script type="text/javascript" src="js/acct.js"></script>                                       <!-- LOGIN script -->	
		<script type='text/javascript' src='js/jquery.simplemodal.js'></script>							<!-- SIMPLEMODAL script -->	
        <link rel="stylesheet" type="text/css" href="css/kickstart.css" media="all" />                  <!-- KICKSTART -->
        <link rel="stylesheet" type="text/css" href="style.css" media="all" />                          <!-- CUSTOM STYLES -->
		<link rel="stylesheet" type="text/css" href="css/navbar.css" media="all" />  
		<script type="text/javascript" >
			jQuery(document).ready(function(){
				
				$('#goBack').live('click', function(){				
					window.location = "./";
				});      
				
				$('#refreshInstall').live('click', function(){				
					window.location = "./install_license.php";
				}); 				
				
				$('#installLicenseLink').text('WEB UI');
				$('#installLicenseLink').attr("href", "./");
							
			});	   
			
		</script> 		
    </head>
    <body>
<?php include 'navbar.php';     ?>
        <div id="wrap" class="clearfix" style="margin-top: 50px;">
            <!-- ===================================== END HEADER ===================================== -->

			<div class="col_12 installLicPanel" style="margin-top: -20px;">
				<form id="upload" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" enctype="multipart/form-data" style="margin:5px 0;">
					<fieldset>
						<legend>Browse for your License</legend>
						<div class="col_10 left">
							<label for="licFile" class="left licLabel" >Select the License File</label>
							<input type="file" id="licFile" name="licFile" required />				
						</div>
						<div id="statusMessage"><?php echo $errLicFile; ?></div>
						<label for="emsLocation" class="col_12 left licLabel" >Enter the directory where Evostream is installed:</label>						
						<div id="emsLocationTextPanel" >
							<input id="emsLocationText" class="col_12" type="text" name="emsLocationText" placeholder="example: /etc/evostreamms/" required value="<?php echo $emsLocationText; ?>" />				
						</div>	
						<div id="statusMessage"><?php echo $errEmsLocationText; ?><?php echo $sucLicFile; ?></div>
						<?php
						echo $installButton;
						echo $backButton;
						?>						
					</fieldset>
				</form>			
			</div>	

            <!-- ===================================== START FOOTER ===================================== -->
            <div class="clear"></div>
            <div id="footer">
                &copy; Copyright 2011–2013 All Rights Reserved. <a href="http://www.evostream.com" target="_blank">Evostream Media Server</a>
            </div>
        </div>
    </body>
</html>
