<?php
/**
 *
 * Copyright (c) 2013, EvoStream Inc.  All rights reserved.
 *
 * This software is provided free of charge to be used solely in conjunction
 * with the EvoStream Media Server.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the source code retain the above 
 * copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Version 2014.01.642
 * 
 * */
require 'phpacct/login.php';
?>
<!DOCTYPE html>
<html>
    <head>
        <title>EvoStream Media Server</title>
        <meta charset="UTF-8">
        <meta name="description" content="" />

        <!-- Grab CDN copy then if offline, revert to local copy -->
        <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <script>window.jQuery || document.write('<script src="js/jquery-1.7.1.min.js"><\/script>')</script>
        <!--[if lt IE 9]><script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
        <script type="text/javascript" src="js/prettify.js"></script>                                   <!-- PRETTIFY -->
        <script type="text/javascript" src="js/kickstart.js"></script>                                  <!-- KICKSTART -->
        <script type="text/javascript" src="js/flowplayer-3.2.10.min.js"></script>                      <!-- Flowplayer script -->
        <script type="text/javascript" src="js/ui.js"></script>                                         <!-- EMS UI script -->
        <script type="text/javascript" src="js/acct.js"></script>                                       <!-- LOGIN script -->	
		<script type='text/javascript' src='js/jquery.simplemodal.js'></script>							<!-- SIMPLEMODAL script -->	                               <!-- EMS UI script -->

        <link rel="stylesheet" type="text/css" href="css/kickstart.css" media="all" />                  <!-- KICKSTART -->
        <link rel="stylesheet" type="text/css" href="style.css" media="all" />                          <!-- CUSTOM STYLES -->
		<link rel="stylesheet" type="text/css" href="css/navbar.css" media="all" />  

    </head>
    <body>
		<?php include 'navbar.php'; ?>			
        <div id="wrap" class="clearfix" style="margin-top: 50px;">
            <!-- ===================================== END HEADER ===================================== -->

            <!-- This is the EMS banner -->
            <div class="col_12 center">
                <a href="http://www.evostream.com" target="_blank"><div><img src="img/logo.png" /><img src="img/banner.png" /></div></a>
            </div>

            <div class="instructions col_12">
                The <strong>EvoStream Media Server (EMS)</strong> allows you to distribute video to any type of screen you wish to reach. Enter the IP address of your EMS server below to get started. Tell the EMS to go get a new video stream by using the "Add an inbound stream" command.
            </div>

            <!-- HTML kickstart bug (don't remove) -->
            <script type="text/javascript">
            </script>		
		<?php if ((!empty($data)) && ( $data['username'] == 'admin')) { ?>

				<div style=" float: left;" class="col_6">
					<button id="accountSettings" type="button" class="pop "><i class="icon-cogs"></i> Account Settings</button>&nbsp;
				</div>	

				<div id="changePasswordPanel" class="hide" >
					<h5 >Change the Password</h5>				
					<div id="changePasswordError"></div>										
					<label class="col_5" >Enter Password</label>
					<br />
					<input  type="password" id="changePasswordText" class="col_12 tooltip" />
					<br />	
					<div class="col_102 right">
						<button id="okChangePassword" type="button" class="pop blue" >Ok</button>&nbsp;<button id="cancelChangePassword" class="pop blue simplemodal-close" type="button" >Cancel</button>
					</div>											
				</div>	

				<div id='alertBox' class="hide" >
					<div class='header'>Alert Message</span></div>
					<div class='col_8 message' ></div>
					<div class="right buttonPanel" >
						<button  type="button" class="pop blue ok simplemodal-close" >Ok</button>
					</div>	
				</div>			

				<div id="addAccountPanel" class="hide" style="height:auto; width:400px; color:#bbb; background-color:#efeffe; border:1px solid #444; border-radius: 5px 5px 5px 5px; padding:12px;" >	
					<h5 style="color:black; font-weight:bold; " >Account Information</h5>				
					<div id="accountError"></div>
					<label class="col_5" style="color:black; font-weight:bold; " >Enter Username</label>
					<br />					
					<input  type="text" id="usernameText" class="col_12 tooltip" />
					<br />	
					<div id="usernameError"></div>
					<label class="col_5" style="color:black; font-weight:bold; " >Enter Password</label>
					<br />
					<input  type="password" id="passwordText" class="col_12 tooltip" />
					<br />	
					<div id="passwordError"></div>
					<div class="col_102 right">
						<button id="okAddAccount" type="button" class="pop blue" >Ok</button>&nbsp;<button id="cancelAddAccount" class="pop blue simplemodal-close" type="button" >Cancel</button>
					</div>											
				</div>				

				<div id="accountSettingsPanel" class="hide col_12" >
					<fieldset >
						<div id="globalSettings" >
							<form>
								<h5>Account Lists</h5>
								<br />
								<table id="accountTable" cellspacing="0" cellpadding="0" class="striped">
									<thead >
										<tr>
											<th class="center">Username </th>
											<th class="center" colspan="2" >Password</th>
											<th class="center">Action</th>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
								<div style="float: right;">
									<button id="cmdAddAccount" type="button" class="pop blue" >Add Another User</button>
								</div>
							</form>
						</div>	
					</fieldset >						
				</div>	

		<?php } ?>

            <div class="col_12"> <!-- Start Main DIV -->

                <!-- Checking of EMS server connection goes here -->
                <label for="ipAddress"><em>Enter IP address of EMS:</em></label>&nbsp;
                <input id="ipAddress" type="text" name="ipAddress" placeholder="valid IP address..." />&nbsp;
                <button id="checkServer" type="button" class="pop"><span class="icon small" data-icon="_"></span>Connect...</button>
                <div id="statusMessage"></div>
				<br />
				<a id="ipWebroot">Enter webserver root directory:</a>
				<div id="ipWebrootTextPanel" class="hide">
					<input id="ipWebrootText" class="col_12" type="text" name="ipWebrootText" placeholder="valid location..." />				
				</div>				
				<div id="webRootStatus"></div>

                <!-- Server commands -->
                <div id="serverComandContainer" class="hide">

                    <fieldset>
                        <legend>Server Commands</legend>
                        <select id="commandList" class="fancy" style="width: 540px;">
                            <option value="none"> -- Choose -- </option>
                            <option value="addStream">Add an inbound stream</option>
                            <option value="createHLS">Create an HLS stream</option>
							<option value="createHDS">Create an HDS stream</option>
                            <option value="listStream">Update stream list</option>
                            <option value="removeStream">Remove existing stream</option>
                            <option value="sendMpegTs">Send MPEG-TS</option>
                        </select>

                        <!-- Container for Add command -->
                        <div id="cmdAdd" class="hide">
                            <label for="streamName" class="col_3"><em>Stream Name:</em></label>
                            <input id="streamName" class="col_9" style="width: 73%;" type="text" placeholder="name of stream..." />
                            <label for="streamSource" class="col_3"><em>Stream Source:</em></label>
                            <input id="streamSource" class="col_9" style="width: 73%;" type="text" placeholder="source with protocol type..." /> <br />
							<input type="checkbox" id="forceTcp" checked="checked" /> <label for="forceTcp" class="inline"><em>Force TCP</em></label> <br />
                            <div class="notice cmdIns">Enter the required parameters then hit the 'Add Stream' button.</div>
                            <button id="cmdAddButton" type="button" class="pop blue"><span class="icon small" data-icon="p"></span>Add Stream</button>
                        </div>

                        <!-- Container for Remove command -->
                        <div id="cmdRemove" class="hide">
                            <div id="remNotice" class="notice cmdIns">Select a stream from the list to delete.</div>
                            <button id="cmdRemButton" type="button" class="pop blue"><span class="icon small" data-icon="m"></span>Remove Stream</button>
                        </div>

                        <!-- Container for HLS command -->
                        <div id="cmdHLS" class="hide">
                            <label for="folderHls" class="col_9"><em>Target Folder (absolute path):</em></label>
                            <input id="folderHls" class="col_9" style="width: 73%;" type="text" placeholder="webserver root folder" />
                            <label for="gNameHls" class="col_3"><em>Group Name:</em></label>
                            <input id="gNameHls" class="col_9" style="width: 73%;" type="text" placeholder="hls_group_xXXx" />
                            <label for="chunkLenHls" class="col_3"><em>Chunk Length:</em></label>
                            <input id="chunkLenHls" class="col_9" style="width: 73%;" type="text" placeholder="10" />
                            <div id="hlsNotice" class="notice cmdIns">Select a stream from the list and populate the settings to create an HLS stream.</div>
                            <button id="cmdHlsButton" type="button" class="pop blue"><span class="icon small" data-icon="("></span>Create HLS Stream</button>
                        </div>

                        <!-- Container for HDS command -->
                        <div id="cmdHDS" class="hide">
                            <label for="folderHds" class="col_9"><em>Target Folder (absolute path):</em></label>
                            <input id="folderHds" class="col_9" style="width: 73%;" type="text" placeholder="webserver root folder" />
                            <label for="gNameHds" class="col_3"><em>Group Name:</em></label>
                            <input id="gNameHds" class="col_9" style="width: 73%;" type="text" placeholder="hds_group_xXXx" />
                            <label for="chunkLenHds" class="col_3"><em>Chunk Length:</em></label>
                            <input id="chunkLenHds" class="col_9" style="width: 73%;" type="text" placeholder="10" />
                            <div id="hdsNotice" class="notice cmdIns">Select a stream from the list and populate the settings to create an HDS stream.</div>
                            <button id="cmdHdsButton" type="button" class="pop blue"><span class="icon small" data-icon="("></span>Create HDS Stream</button>
                        </div>						

                        <!-- Container for MPEG-TS command -->
                        <div id="cmdMpegSend" class="hide">
                            <label for="targetMpg" class="col_3"><em>Target Address</em></label>
                            <input id="targetMpg" class="col_9" style="width: 73%;" type="text" placeholder="media server..." />
                            <label for="targetPortMpg" class="col_3"><em>Target Port</em></label>
                            <input id="targetPortMpg" class="col_9" style="width: 73%;" type="text" placeholder="10000" />
                            <div id="mpgNotice" class="notice cmdIns">Select a stream from the list and enter a target address where MPEG-TS UDP packets should be sent.</div>
                            <button id="cmdSendMpgButton" type="button" class="pop blue"><span class="icon small" data-icon=")"></span>Send MPEG-TS Stream</button>&nbsp;
                            <button id="cmdStopMpgButton" type="button" class="pop blue"><span class="icon small" data-icon="x"></span>Stop all MPEG-TS Streams</button>
                        </div>

                    </fieldset>

                </div>

                <!-- Stream List -->
                <div id="streamList" class="hide"></div>

                <!-- Stream Details -->
                <div id="streamDetail" class="instructions col_12 hide">
                    <h5>Stream Details</h5>
                    <label class="col_2"><em>Name:</em></label><input id="nameSrc" class="col_10" readonly="readonly" />
                    <label class="col_2"><em>Source:</em></label><input id="srcSrc" class="col_10" readonly="readonly" />
                    <label class="col_2"><em>RTMP:</em></label><input id="rtmpSrc" class="col_10" readonly="readonly" />
                    <label class="col_2"><em>RTSP:</em></label><input id="rtspSrc" class="col_10" readonly="readonly" />
                    <input id="idSrc" type="hidden" />
                    <br /><br />
                    <button id="playVid" type="button" class="pop blue"><span class="icon small" data-icon="2"></span>Play Video</button>
                </div>

                <!-- Video container -->
                <div id="videoContainer" class="col_12 hide" style="border:1px solid lightblue; background: #000; height: 300px; z-index:-1;"></div>

            </div> <!-- End Main DIV -->


            <!-- ===================================== START FOOTER ===================================== -->
            <div class="clear"></div>
            <div id="footer">
                &copy; Copyright 2011–2013 All Rights Reserved. <a href="http://www.evostream.com" target="_blank">Evostream Media Server</a>
            </div>

        </div><!-- END WRAP -->
    </body>
</html>
